/*
 * Decompiled with CFR 0.152.
 */
class individual {
    cell cell;
    individual prev;
    individual next;
    public species species;
    int genbreed;
    int genstarve;

    public individual(cell acell, species aspecies) {
        this.cell = acell;
        this.prev = this.next = this;
        this.species = aspecies;
        if (this.species != null) {
            ++this.species.cnt;
        }
    }

    public void tallyneighbor() {
        this.species.tallyneighbor(this);
    }

    public individual gen() {
        individual food;
        if (this.genbreed > 0) {
            --this.genbreed;
        }
        if (this.genstarve > 0) {
            --this.genstarve;
        }
        this.species.menagerie.clearneighborcnts();
        this.cell.dealneighbors();
        individual open = food = this.species.pickfood();
        if (food != null) {
            this.genstarve = this.species.genstarve;
            food.die();
        } else {
            open = this.genstarve == 0 ? this : this.species.pickocean();
        }
        if (open != null) {
            this.swap(open);
        }
        individual oldnext = this.next;
        if (open != null && this.genbreed == 0) {
            this.genbreed = this.species.genbreed;
            open.breed(this.species, oldnext);
        } else if (this.genstarve == 0) {
            this.die();
        }
        if (open != null) {
            this.draw();
            if (open != this) {
                open.draw();
            }
        }
        return oldnext;
    }

    public void draw() {
        this.species.menagerie.drawcell(this.species.color, this.cell.drawrow, this.cell.drawcol);
    }

    public void die() {
        this.unlink();
        this.setspecies(this.species.menagerie.ocean);
    }

    public void breed(species aspecies, individual anext) {
        this.unlink();
        this.setspecies(aspecies);
        this.append(anext);
        this.genbreed = this.species.menagerie.rnd.get2(this.species.genbreed);
        this.genstarve = this.species.menagerie.rnd.get2(this.species.genstarve);
    }

    public void setspecies(species aspecies) {
        --this.species.cnt;
        this.species = aspecies;
        ++this.species.cnt;
    }

    public void swapcell(individual aindividual) {
        cell c = this.cell;
        this.cell = aindividual.cell;
        aindividual.cell = c;
    }

    public void swap(individual aindividual) {
        this.cell.swapindividual(aindividual.cell);
        this.swapcell(aindividual);
    }

    public void append(individual aindividual) {
        this.next.prev = aindividual.prev;
        aindividual.prev.next = this.next;
        this.next = aindividual;
        aindividual.prev = this;
    }

    public void insert(individual aindividual) {
        aindividual.append(this);
    }

    public void unlink() {
        this.next.prev = this.prev;
        this.prev.next = this.next;
        this.next = this.prev = this;
    }
}

